-------------------------------------------------------------------------------
--
--    Multitap Factory & Assistance
--
--    Author:       Telperion
--    Date:         2019-11-29
--    Version:      1.1.2
--    Target:       SM 5.0.12, SM 5.1.0, ITGM 0.5.1
--    Contributors: quietly-turning
--
-------------------------------------------------------------------------------
--
--    So, like...it's been three years since UKSRT8 and TaroNuke's
--    "Hardware Bullshit Tournament", the event where a prototype of a dance
--    pad with fine-grained pressure response got an exhibition with a whole
--    set of files featuring new (to 4-panel) chart mechanics. It really was
--    a blast! and I've wished for a while now that there would eventually be
--    some way to play the whole thing at home.
--
--    During a post-UKSRTX hangout, Taro lugged the platform out so newcomers
--    who hadn't been around for UKSRT8 could give the HBT files a shot.
--    While watching, something clicked in my brain: the pieces of a few
--    half-finished SM5 mods files I had lying around could be assembled,
--    with a little extra work, into the HBT multitap note type.
--    [https://www.youtube.com/watch?v=OQiZJ38fDJM&t=1m04s]
--
--    I got to sweep out some very dark corners of StepMania 5 with this one:
--    * You can just *make* fakes and explosions, if you hook them up right
--    * Really glad non-beat-subtracting offset zoom splines work the way
--      I expected, because I couldn't think of any sensible other options
--    * Parameter ordering in ArrowEffects:Get<>() calls is spicy
--      (which will eventually require an update to this code, because
--      I opened my big mouth :P)
--    * Sad about lack of access to the FOV and vanishing point of an actor
--      (straight up translated portions of the C++ source for that)
--    * Mysterious version-dependent radian poltergeist?? hello??????
--    * I didn't actually know propagatecommand existed until I wrote a
--      (poorly-covering) function to do the same thing with reflection
--    * Kinda wish there was a generic way to retrieve the color scheme of
--      a rhythm noteskin (e.g., solo vs. note)
--    * Playfields aren't vertically centered in the screen and this is
--      *theme-dependent* and although I understand why that might be
--      useful I sure as hell am allowed to complain about it
--
--    But the upshot is:
--    *  You can write your own multitap files!
--      1.  Copy this FG animation (multitap\*) into your song directory
--      2.  Copy the #FGCHANGES: line into your .ssc file
--      3.  Replace multitap_data.lua to suit your chart
--        (eventually I will also provide autogeneration code for this
--        based on interpreting the corresponding double slot)
--      4.  Increase brain wrinkliness
--      5a.  Have a tappy slappy time
--      5b.  Recoil in horror from what you have brought into existence
--    * Multitaps should be compatible with most common SM5 noteskins
--    * Multitaps will act like regular taps under all* mods
--    * Multitap-enabled files will work on most cabs running
--      SM5.0.12+ and Simply Love
--
--    TODO:
--    * Soften the hardcoding of 4-panel mode
--    * Soften use of 45-degree FOV for spoofing perspective mods (just in
--      case other FG changes want to mess with that)
--    * Haven't figured out how to implement arrow glow yet (for use
--      during stealth/hidden/sudden sections)
--    * Some themes (Lambda in particular) throw off my Mini calculations
--    * Track down the mysterious version-dependent radian poltergeist
--    *  Multitaps under Cmod don't move smoothly. For now I'm pretending
--      this is a feature :)
--    * nITG compatibility...
--
--    TRICKY:
--    * This implementation of multitaps locks down zoom splines - no
--      additional FG animations should attempt to use them without
--      accounting for the multitap regions
--    * Anything in the multitap regions will be hidden, but only taps get
--      re-presented to the player. Lifts, mines, and fakes will be
--      invisible (but still hittable...)
--
-------------------------------------------------------------------------------
--
-- note from quietly-turning:
-- thanks for this framework, Telperion!  you certainly know your stuff.  :^)
--
-- I've slightly modified this file!  Here's what's new in version 1.1.1:
--
--    * allow different difficulties to have and not-have multitap data
--      and to be played simultaneously without throwing Lua errors
--    * play multitap data in SM5's editor
--      I tested in 5.1-beta but 5.0.12 should work fine, too.
--
-- Helpful notes:
--    * this framework currently expects all available columns to have
--      and use multitap data!  you'll need to include multitap data for
--      for all 4 columns in your multitap_data.lua file, and write your
--      stepchart accordingly.
--
--      I don't understand this Lua framework and SM5's NCSplineHandler
--      well enough to know how to change this.
--
--
-- ---------------
-- update from quietly-turning:
--    new in version 1.1.2
--
--    * I added an extra check to see if ITGMania is being used and if it's at
--      version 0.5.1.
--      the MYSTERIOUS_VERSION_DEPENDENT_RADIAN_POLTERGEIST variable previously
--      checked if the version was "5.1.0".  ITGMania has since become a thing and,
--      at the time of me writing this, is at version "0.5.1", which fails the check
--      of "5.1.0".  Piling on extra conditionals in this multitap framework works
--      for now, but Someone Should™ investigate what changed in the engine between
--      5.0.12 and 5.1.
-------------------------------------------------------------------------------


--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--
--
-- Some helper functions I haven't isolated yet

-- -------------------------------------------------------------------------------
-- helper function for detecting if we're in edit mode right now
-- returns: boolean

local IsEditMode = function()
	local topscreen = SCREENMAN:GetTopScreen()
	if not topscreen then
	  lua.ReportScriptError("IsEditMode() check failed to run because there is no Screen yet.")
	  return nil
	end
  
	return (THEME:GetMetric(topscreen:GetName(), "Class") == "ScreenEdit")
  end
  
  -- helper function for returning the player AF
  -- works as expected in ScreenGameplay
  -- uses IsEditMode() to find the player AF if we're in EditMode
  --     arguments:  pn is a number like 1 or 2
  --     returns:    the "PlayerP1" or "PlayerP2" ActorFrame in ScreenGameplay
  --                 or, the unnamed equivalent in ScrenEdit
  local GetPlayerAF = function(pn)
	local topscreen = SCREENMAN:GetTopScreen()
	if not topscreen then
	  lua.ReportScriptError("GetPlayerAF() failed to find the player ActorFrame because there is no Screen yet.")
	  return nil
	end
  
	local playerAF = nil
  
	-- Get the player ActorFrame on ScreenGameplay
	-- It's a direct child of the screen and named "PlayerP1" for P1
	-- and "PlayerP2" for P2.
	-- This naming convention is hardcoded in the SM5 engine.
	--
	-- ScreenEdit does not name its player ActorFrame, but we can still find it.
  
	-- find the player ActorFrame in edit mode
	if IsEditMode() then
	  -- loop through all nameless children of topscreen
	  -- and find the one that contains the NoteField
	  -- which is thankfully still named "NoteField"
	  for _,nameless_child in ipairs(topscreen:GetChild("")) do
		if nameless_child:GetChild("NoteField") then
		  playerAF = nameless_child
		  break
		end
	  end
  
	-- find the player ActorFrame in gameplay
	else
	  local player_af = topscreen:GetChild("PlayerP"..pn)
	  if player_af then
		playerAF = player_af
	  end
	end
  
	return playerAF
  end

local player_actors = {{},{}}
local playerStats = {goal = {0, 0},
					 score = {0, 0},
					 check = {false, false},
					 pass = {{false, false}, {false, false}},
					drillTap = {false, false},
					lane = {0, 0}}
local goalIndex = 1
--Each player step equates to 1 beach point
inputAction = {
	['Left']  = 	function(input_player) 
		if GAMESTATE:GetSongBeat() > 358 and GAMESTATE:GetSongBeat() < 373 then
			playerStats.score[input_player] = playerStats.score[input_player] + 1 
		end
	end,
	['Down']  = 	function(input_player) playerStats.score[input_player] = playerStats.score[input_player] + 0 end,
	['Up']    = 	function(input_player) playerStats.score[input_player] = playerStats.score[input_player] + 0 end,
	['Right'] = 	function(input_player) 
		if GAMESTATE:GetSongBeat() > 71 and GAMESTATE:GetSongBeat() < 87 then
			playerStats.score[input_player] = playerStats.score[input_player] + 1 
		end
	end}

	InputHandler = function(event)	
		if event.type == 'InputEventType_FirstPress' and event.PlayerNumber then 		
			local input_player = event.PlayerNumber == "PlayerNumber_P1" and 1 or 2
			if playerStats.drillTap[input_player] then
				if event.button then
					if inputAction[event.button] then
						inputAction[event.button](input_player)	
					end
				end	
			end
		end	
	end

local function game_init()
	SCREENMAN:GetTopScreen():GetChild('Overlay'):z(-2000)
    SCREENMAN:GetTopScreen():GetChild('Overlay'):diffuse(0,0,0,1)
	SCREENMAN:GetTopScreen():GetChild('Underlay'):z(-2000)
    SCREENMAN:GetTopScreen():GetChild('Underlay'):diffuse(0,0,0,1)
end

local goalByDifficulty = {60, 100}
local apple = ""
local bidenCheck = false
local function game_update(self, delta)

	for i=1,2 do
		if GetPlayerAF(i) then
			-- if not playerStats.check[i] then
			-- 	playerStats.goal[i] = goalByDifficulty[goalIndex]		
			-- 	playerStats.check[i] = true
			-- end
			if GAMESTATE:GetSongBeat() > 71 and GAMESTATE:GetSongBeat() < 87 then
				playerStats.goal[i] = goalByDifficulty[1]		
				playerStats.drillTap[i] = true
				drillTap = true		
			else
				if GAMESTATE:GetSongBeat() > 358 and GAMESTATE:GetSongBeat() < 373 then
					playerStats.goal[i] = goalByDifficulty[2]		
					playerStats.drillTap[i] = true
					drillTap = true	
				else
					if playerStats.drillTap[i] then
						-- Check if the player has reached the goal
						if playerStats.score[i] >= playerStats.goal[i] then
							apple = apple .. "Player "..i.." has reached the goal"
							if GAMESTATE:GetSongBeat() > 358 then
								playerStats.pass[i][2] = true
							else
								playerStats.pass[i][1] = true
							end
						else
							if not playerStats.pass[i][1] then
								-- Diffuse each column actor
								for i,column in ipairs(GetPlayerAF(i):GetChild('NoteField'):get_column_actors()) do
									if i == 4 then
										column:diffuse(0,0.3,0,1)
									end
								end
							end
							if not playerStats.pass[i][2] and GAMESTATE:GetSongBeat() > 358  then
								-- Diffuse each column actor
								for i,column in ipairs(GetPlayerAF(i):GetChild('NoteField'):get_column_actors()) do
									if i == 1 then
										column:diffuse(0,0.3,0,1)
									end
								end
							end
							if not playerStats.pass[i][1] and (not playerStats.pass[i][2] and GAMESTATE:GetSongBeat() > 358) then
                for i,column in ipairs(GetPlayerAF(i):GetChild('NoteField'):get_column_actors()) do
                    if not bidenCheck then
                      MESSAGEMAN:Broadcast("BidenBlastCheck")
                      bidenCheck = true
                    end
								end
							end
							apple = apple .. "Player "..i.." has not reached the goal"
						end
					end

					playerStats.drillTap[i] = false
					drillTap = false
					playerStats.score[i] = 0		
				end

			end
		end
	end
end
local multitap_parent =  Def.ActorFrame{
	OnCommand=function(self)
		self:SetUpdateFunction(game_update)	
		SCREENMAN:GetTopScreen():AddInputCallback(InputHandler)
	end,
	Def.Actor{
		Name="#YOLO",
		InitCommand=function(self)
			self:sleep(100)
		end
	}
}

local display = {score = {_screen.w*.063, _screen.w*.937},
				 goal = {_screen.w*.25, _screen.w*.75},
				 brella = {_screen.w*.08, _screen.w*.92}}





if GAMESTATE:GetCurrentGame():GetName() ~= "dance" then return Def.Actor{} end


--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--
--
-- Generate multitap_data.lua using Telperion's Python chart utilities.
-- MultitapsWorkflow(r'C:\path\to\simfile.sm')
--
-- Version matching performed here.
--
--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--
multitaps = {}
multitap_version = {1, 1}

-- Load multitap data into workspace
local whereTheFlipAmI = GAMESTATE:GetCurrentSong():GetSongDir()
dofile(whereTheFlipAmI .. "lua/multitap_data.lua")

-- Compare version of multitap data and multitap parser.
local version_mismatch = function(mv_data, mv_parser)
  SCREENMAN:SystemMessage("### Multitap version mismatch: data @ "..mv_data[1].."."..mv_data[2]..", parser @ "..mv_parser[1].."."..mv_parser[2])
end
local version_record = function(mv_data, mv_parser)
  Trace("### Multitap versions: data @ "..mv_data[1].."."..mv_data[2]..", parser @ "..mv_parser[1].."."..mv_parser[2])
end

if multitaps["_version"] then
  version_record(multitaps["_version"], multitap_version)
  -- Data version major can't be greater than parser version major
  if multitaps["_version"][1] > multitap_version[1] then
    version_mismatch(multitaps["_version"], multitap_version)
    return Def.ActorFrame{}
  end
  -- Data version minor can't be greater than parser version minor
  if (multitaps["_version"][1] == multitap_version[1]) and
    (multitaps["_version"][2] > multitap_version[2]) then
    version_mismatch(multitaps["_version"], multitap_version)
    return Def.ActorFrame{}
  end
else
  SCREENMAN:SystemMessage("### Found unversioned multitap data")
end


-- -------------------------------------------------------------------------------


--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--
--
--     holh fucf?
--
--
--                           HOLKY FUCY???
--
--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--


local IsStepMania = function()
  if type(ProductFamily) ~= "function" then return false end
  return ProductFamily() == "StepMania"
end

local IsITGmania = function()
  if type(ProductFamily) ~= "function" then return false end
  return ProductFamily() == "ITGmania"
end


-- transform a StepMania version string ("5.0.12") into a table of numbers { 5, 0, 12 }
local getProductVersion = function()
  if type(ProductVersion) ~= "function" then return {} end

  -- get the version string, e.g. "5.0.11" or "5.1.0" or "5.2-git-96f9771" or etc.
  local version = ProductVersion()
  if type(version) ~= "string" then return {} end

  -- remove the build suffix from the version string
  -- debug build are suffixed with "-git-$something" or "-UNKNOWN" if the
  -- git hash is not available for some reason
  version = version:gsub("-.*", "")

  -- parse the version string into a table
  local v = {}
  for i in version:gmatch("[^%.]+") do
    table.insert(v, tonumber(i))
  end

  return v
end

local version_numbers = getProductVersion()
local sm_version = ProductVersion()
local MYSTERIOUS_VERSION_DEPENDENT_RADIAN_POLTERGEIST = 0

-- handle [StepMania 5.1.0, ITGMania 0.5.1] differently than StepMania 5.0.12  D:
if (IsStepMania() and (version_numbers[1]==5 and version_numbers[2]==1) or IsITGmania()) then
   MYSTERIOUS_VERSION_DEPENDENT_RADIAN_POLTERGEIST = (-180 / math.pi)
end

-- -------------------------------------------------------------------------------



--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--
--
-- Multitap generation code begins here
--
--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--[[##]]--




-- Controls for tweaking visual behavior of multitaps
local multitap_error = false           -- How is multitap parsing going?
local multitap_previsible = 8          -- Make the multitaps visible this many beats in advance of the first hit
local multitap_basebounce = 2.1          -- Multiplier for initial bounce velocity (1x matches inbound speed)
local multitap_elasticity = 1.2       -- Subsequent bounces get their rebound speed multiplied by this
local multitap_squishy = 0.2          -- Cartoonishly squish the arrow when traveling slowly and expand when fast.
local multitap_splines_calc = {false, false}  -- Spline Times EX should have stayed in pop'n 8. and that's the tea

-- Gotta know how many of these to make.
local multitap_max = 0
for _,mt_list in pairs(multitaps) do
  if multitap_max < #mt_list then
    multitap_max = #mt_list
  end
end

-- Initialize the multitap actor list.
--
--   Player number (1 or 2)
--    Multitap index
--      {frame, arrow, count}
local multitap_actors = {
  {},
  {}
}
for pn = 1,2 do
  for i = 1,multitap_max do
    multitap_actors[pn][i] = {}
  end
end
local multitap_explosions = {
  {},
  {}
}
local multitap_fields = {}

-- Slot and noteskin selection for each player.
local multitap_chart_sel = {
  "Hard",
  "Hard"
}
local noteskin_names = {
  "shadow",
  "shadow"
}

-- Precalculate a table of quantization colors by beat fraction.
-- Used to select a texture offset in the noteskin asset for the tap arrow.
local qtzn_lookup = {}
for _,qtzn in ipairs({48, 24, 16, 12, 8, 6, 4, 3, 2, 1}) do
  for i = 0,48,(48/qtzn) do
    qtzn_lookup[i] = qtzn
  end
end

local qtzn_tex = {}
qtzn_tex[ 0] = 0
qtzn_tex[ 1] = 0
qtzn_tex[ 2] = 1
qtzn_tex[ 3] = 2
qtzn_tex[ 4] = 3
qtzn_tex[ 6] = 4
qtzn_tex[ 8] = 5
qtzn_tex[12] = 6
qtzn_tex[16] = 7
qtzn_tex[24] = 7
qtzn_tex[48] = 7


-- I don't think it's reasonable within the UPS5 submission timeframe to
-- dynamically pull/calculate the actual *color* of each quantization for
-- an arbitrary noteskin, so I'm precalculating some options based on the
-- Cabby noteskin pack.
local qtzn_color_tables = {
  vivid = {          -- whole texture I'm fucking busy only get few color
    {"ffffff", "cccccc"},  -- 4ths
    {"ffffff", "cccccc"},  -- 8ths
    {"ffffff", "cccccc"},  -- 12ths
    {"ffffff", "cccccc"},  -- 16ths
    {"ffffff", "cccccc"},  -- 24ths
    {"ffffff", "cccccc"},  -- 32nds
    {"ffffff", "cccccc"},  -- 64ths
    {"ffffff", "cccccc"},  -- 192nds
  },
  shadow = {          -- best colorblindness acuity in the noteskins sharing the ITG palette
    {"ff6100", "ff0000"},  -- 4ths
    {"00a2ff", "00f0ff"},  -- 8ths
    {"fa81d1", "7a15fe"},  -- 12ths
    {"e2f90f", "09a357"},  -- 16ths
    {"fa81d1", "7a15fe"},  -- 24ths
    {"f1db03", "e67b02"},  -- 32nds
    {"33fc7b", "04b8b6"},  -- 64ths
    {"33fc7b", "04b8b6"},  -- 192nds
  },
  color = {          -- the most like unto the true DDR Note noteskin
    {"ffc5c5", "ff0000"},  -- 4ths
    {"0000ff", "c5c5ff"},  -- 8ths
    {"00ff00", "c5ffc5"},  -- 12ths
    {"fff617", "646001"},  -- 16ths
    {"00ff00", "c5ffc5"},  -- 24ths
    {"00ff00", "c5ffc5"},  -- 32nds
    {"00ff00", "c5ffc5"},  -- 64ths
    {"00ff00", "c5ffc5"},  -- 192nds
  },
  note = {          -- this is what the DDR Note noteskin should have been
    {"ff7c7c", "ff2121"},  -- 4ths
    {"7e86f4", "2432ec"},  -- 8ths
    {"be77fb", "9018f8"},  -- 12ths
    {"faff73", "f7ff11"},  -- 16ths
    {"f383bf", "eb2c93"},  -- 24ths
    {"ff966d", "ff4d06"},  -- 32nds
    {"90e3ff", "43d0ff"},  -- 64ths
    {"85ff7c", "30ff20"},  -- 192nds
  },
  rainbow = {          -- some time...you just haven`t care
    {"ff6100", "ff0000"},  -- 4ths
    {"00a2ff", "00f0ff"},  -- 8ths
    {"fa81d1", "7a15fe"},  -- 12ths
    {"fa81d1", "7a15fe"},  -- 16ths
    {"fa81d1", "7a15fe"},  -- 24ths
    {"fa81d1", "7a15fe"},  -- 32nds
    {"fa81d1", "7a15fe"},  -- 64ths
    {"fa81d1", "7a15fe"},  -- 192nds
  },
  horseshoe = {        -- I think it's very unprofessional of the official Trot 100 News account to try and cancel an artist.
    {"dfa9db", "a96fba"},  -- 4ths
    {"faba61", "d49234"},  -- 8ths
    {"98d3f1", "2c78b6"},  -- 12ths
    {"fe96b9", "b7366e"},  -- 16ths
    {"b6b3d5", "6947bf"},  -- 24ths
    {"f0e56e", "eae6bf"},  -- 32nds
    {"8b7bff", "503497"},  -- 64ths
    {"ebe6ad", "edb032"},  -- 192nds
  },
}
-- Anything not explicitly assigned here will pick up the "vivid" behavior (no color distinction).
qtzn_color_tables["ascii"]              = qtzn_color_tables["note"]
qtzn_color_tables["cel"]                = qtzn_color_tables["shadow"]
--qtzn_color_tables["color"]
qtzn_color_tables["cyber"]              = qtzn_color_tables["shadow"]
qtzn_color_tables["default"]            = qtzn_color_tables["note"]
qtzn_color_tables["delta"]              = qtzn_color_tables["shadow"]
qtzn_color_tables["enchantment"]        = qtzn_color_tables["shadow"]
qtzn_color_tables["easyv2"]             = qtzn_color_tables["note"]
qtzn_color_tables["exactv2"]            = qtzn_color_tables["note"]
qtzn_color_tables["excel"]              = qtzn_color_tables["shadow"]
qtzn_color_tables["excelx"]             = qtzn_color_tables["shadow"]
qtzn_color_tables["horsehorsenote"]     = qtzn_color_tables["note"]
qtzn_color_tables["horsegroove"]        = qtzn_color_tables["shadow"]
qtzn_color_tables["horsenote"]          = qtzn_color_tables["note"]
qtzn_color_tables["horsemaniax"]        = qtzn_color_tables["shadow"]
--qtzn_color_tables["horseshoe"]
qtzn_color_tables["lambda"]             = qtzn_color_tables["note"]
qtzn_color_tables["metal"]              = qtzn_color_tables["shadow"]
qtzn_color_tables["midi-note"]          = qtzn_color_tables["note"]
qtzn_color_tables["midi-note-3d"]       = qtzn_color_tables["note"]
qtzn_color_tables["midi-solo"]          = qtzn_color_tables["rainbow"]
--qtzn_color_tables["note"]
qtzn_color_tables["onlyonecouples"]     = qtzn_color_tables["shadow"]
qtzn_color_tables["peter-ddrlike"]      = qtzn_color_tables["shadow"]
qtzn_color_tables["peterddrnote"]       = qtzn_color_tables["color"]
qtzn_color_tables["peterddrrainbow"]    = qtzn_color_tables["rainbow"]
qtzn_color_tables["peters-ddrlike"]     = qtzn_color_tables["shadow"]
qtzn_color_tables["peters-ddr-note"]    = qtzn_color_tables["color"]
qtzn_color_tables["peters-ddr-rainbow"] = qtzn_color_tables["rainbow"]
qtzn_color_tables["peters-scalable-cel"]= qtzn_color_tables["shadow"]
qtzn_color_tables["peters-scalable-vibrantmetal"] = qtzn_color_tables["shadow"]
--qtzn_color_tables["rainbow"]
qtzn_color_tables["retro"]              = qtzn_color_tables["note"]
qtzn_color_tables["retrobar"]           = qtzn_color_tables["note"]
--qtzn_color_tables["shadow"]
qtzn_color_tables["scalable"]           = qtzn_color_tables["shadow"]
qtzn_color_tables["scalable-cel"]       = qtzn_color_tables["shadow"]
qtzn_color_tables["scalable-metal"]     = qtzn_color_tables["shadow"]
qtzn_color_tables["solo"]               = qtzn_color_tables["rainbow"]
qtzn_color_tables["spotlight"]          = qtzn_color_tables["shadow"]
qtzn_color_tables["toonprints"]         = qtzn_color_tables["horseshoe"]
qtzn_color_tables["trax"]               = qtzn_color_tables["note"]
qtzn_color_tables["vel"]                = qtzn_color_tables["shadow"]
qtzn_color_tables["vibrant-cel"]        = qtzn_color_tables["shadow"]
qtzn_color_tables["vibrant-metal"]      = qtzn_color_tables["shadow"]
qtzn_color_tables["vintage"]            = qtzn_color_tables["shadow"]
--qtzn_color_tables["vivid"]

local _BB = function(b)
  -- Measure beats in increments of 192nds (= 1/48 of quarter notes).
  return math.floor(b*48 + 0.5)
end

local calc_qtzn = function(b)
  -- What quantization is this beat number?
  -- e.g., quarter = 1, 16th = 4, 24th = 6, etc.

  -- Graceful fallback for no-tap case.
  if not b then
    return 0
  end

  -- Each quarter can be divided into 48 steps.
  -- Get the nearest proper step.
  local d48 = math.floor(b*48 + 0.5) - math.floor(b)*48

  -- Decide where it falls.
  return qtzn_lookup[d48]
end

local parabolator = function(b, t, elastic)
  -- b = beat length of this multitap iteration
  -- t = time in beats since the start of this multitap iteration
  -- elastic = scaling of arrowpath position (1 = perfect bounce from approach speed, 0 = dead stop)
  -- returns distance back up the arrow path to travel
  --
  -- f(t) = v/b * t * (b - t), where v = approach speed
  -- we can get around needing to know the pixelar speed of the arrow by calculating distance
  -- in terms of beats traveled @ whatever the reading speed is.
  -- therefore the approach is always 1 beat/beat >:)
  if not elastic then
    elastic = 1
  end
  return elastic * t * (b-t) / b
end

local parabolator_dt = function(b, t, elastic)
  -- b = beat length of this multitap iteration
  -- t = time in beats since the start of this multitap iteration
  -- elastic = scaling of arrowpath position (1 = perfect bounce from approach speed, 0 = dead stop)
  -- returns distance back up the arrow path to travel
  --
  -- f(t) = v/b * t * (b - t), where v = approach speed
  -- we can get around needing to know the pixelar speed of the arrow by calculating distance
  -- in terms of beats traveled @ whatever the reading speed is.
  -- therefore the approach is always 1 beat/beat >:)
  if not elastic then
    elastic = 1
  end
  return elastic * (b - 2*t) / b
end

local calc_multitap_phase = function(mt_desc, b, pn)
  -- mt_desc = multitap descriptor with the following elements:
  --    lane: which lane the tap is in (unimportant here)
  --    taps: tap beat times included in this multitap
  -- b = current beat
  -- pn = Player number - necessary for Drill taps
  -- returns a table with the following elements:
  --    rem: # of hits left (the multitap should show a number if it's more than 1)
  --    pos: position in beats before receptors
  --    qtc: quantization of currently approaching note
  --    qtn: quantization of next note in the multitap (used to color the number)
  --    dif: diffuse arrow from 0 (dark) to 1 (full brightness)
  --    vis: currently visible (true/false)
  
  local ret = {
    rem = 0,
    pos = 0,
    sqh = 0,
    qtc = 0,
    qtn = 0,
    dif = 0,
    vis = false
  }
  
  if not mt_desc then
    Trace("No multitap descriptor??")
    multitap_error = true
    return ret
  end
  local mt_taps = mt_desc["taps"]
  if not mt_taps then
    Trace("No tap description in multitap??")
    multitap_error = true
    return ret
  end

  if #mt_taps == 0 then
    Trace("An empty multitap is fine I guess")
    return ret
  end
  if b > mt_taps[#mt_taps] then
    -- Already past the last tap! But don't yell about it. Loudmouth
    return ret
  end

  -- Basic case for when we're earlier than the first tap.
  ret.rem = #mt_taps
  ret.pos = mt_taps[1] - b
  ret.sqh = 0
  ret.qtc = calc_qtzn(mt_taps[1])
  ret.qtn = mt_desc["type"] == "Drill" and 6 or calc_qtzn(mt_taps[2])
  ret.dif = 0
  ret.vis = (ret.pos < multitap_previsible)

  if (mt_desc["type"] == "Drill") then
		if not playerStats.check[pn] then
			playerStats.check[pn] = true
		end
    playerStats.lane[pn] = mt_desc["lane"]
    ret.rem = mt_desc["goal"] - playerStats.score[pn]
    -- Start with the elasticity at the baseline,
    -- or if the "peak" parameter is set for this multitap, substitute it directly.
    local el = (mt_desc["peak"] and mt_taps[2]) and (mt_desc["peak"] / (mt_taps[2] - mt_taps[1])) or 0
    for i = 1,#mt_taps do
      -- Any bounce cases happen here.
      if b <= mt_taps[1] then
        break
      end
      if b >= mt_taps[2] then
      end

      if mt_desc["goal"] - playerStats.score[pn] <= 0 then
        --SM(playerStats.goal[pn] - playerStats.score[pn])
      end

      el = mt_desc["peak"] and (mt_desc["peak"] / (mt_taps[i+1] - mt_taps[i])) or (el * 1)
      -- Compound the elasticity, or continue to hold the peak constant.

      -- We're assured to have an i+1 element here because
      -- we've already jumped out when b > mt_taps[#mt_taps].
      ret.pos = parabolator(mt_taps[2] - mt_taps[1], b - mt_taps[1], el)
      ret.sqh = multitap_squishy*(math.abs(parabolator_dt(mt_taps[2] - mt_taps[1], b - mt_taps[1], 1.25)) - 0.5)
      ret.qtc = 1
      ret.qtn = 6
      ret.dif = 0.5
      ret.vis = true
    end
  else
	-- Start with the elasticity at the baseline,
	-- or if the "peak" parameter is set for this multitap, substitute it directly.
	local el = (mt_desc["peak"] and mt_taps[2]) and (mt_desc["peak"] / (mt_taps[2] - mt_taps[1])) or multitap_basebounce


	for i = 1,#mt_taps do
		-- Any bounce cases happen here.
		if b <= mt_taps[i] then
		break
		end
		if mt_desc["type"] == "Flowers" then
			el = mt_desc["peak"] and (mt_desc["peak"] / (mt_taps[i+1] - mt_taps[i])) or (el * 1)
		else
			el = mt_desc["peak"] and (mt_desc["peak"] / (mt_taps[i+1] - mt_taps[i])) or (el * multitap_elasticity)
		end
		-- Compound the elasticity, or continue to hold the peak constant.

		-- We're assured to have an i+1 element here because
		-- we've already jumped out when b > mt_taps[#mt_taps].
		ret.rem = #mt_taps - i
		ret.pos = parabolator(mt_taps[i+1] - mt_taps[i], b - mt_taps[i], el)
		ret.sqh = multitap_squishy*(math.abs(parabolator_dt(mt_taps[i+1] - mt_taps[i], b - mt_taps[i], el)) - 0.5)
		ret.qtc = calc_qtzn(mt_taps[i+1])
		ret.qtn = calc_qtzn(mt_taps[i+2])
		ret.dif = i / (#mt_taps-1)
		ret.vis = true
	end
  end

  return ret
end

-- Provide a custom explosion callback message for each player.
-- The false explosions give better visual reinforcement for multitap hits.
for i=1,2 do
  local pn = i
  _G["multitap_note_callback_P"..i] = function(lane, tns, is_bright)

    -- -----------------------------------------------------
    -- if we're in EditMode and doing anything other than watching playback
    -- don't propagate any commands to multitap_explosions
    --     the multitap_explosions ActorFrame will be "stale"
    --     "referenced ActorFrame was used but no longer exists"
    -- only propagate if we're watching playback       -quietly
    -- -----------------------------------------------------
    if IsEditMode() then
      local topscreen = SCREENMAN:GetTopScreen()
      if not (topscreen and topscreen:GetEditState() == 'EditState_Playing') then
        return
      end
    end
    -- -----------------------------------------------------

    if multitap_explosions[pn][lane] then
      --Trace("??? do explosion pls")
      multitap_explosions[pn][lane]:propagatecommand("Judgment")
      multitap_explosions[pn][lane]:propagatecommand("Dim")
      multitap_explosions[pn][lane]:propagatecommand(string.sub(tns, 14))
    end
  end
end

local calc_zoom_splines = function(mt_table, pn)
  -- Use non-beat-subtracting offset zoom splines to hide real taps.
  --
  -- Wait, what?
  --
  -- Non-beat-subtracting
  --    Think of the spline as traveling along with the arrows, rather than
  --    staying fixed to the player's viewable section of the chart.
  -- Offset
  --    Instead of overwriting the original arrow path, the spline is
  --    applied as a change to that path. Here we use zooms of 0 or -1,
  --    representing (1 + 0)x = visible or (1 + -1)x = invisible.
  -- Zoom spline
  --    Set a mathematical function that describes the scaling of an arrow
  --    landing on any given beat.

  if not mt_table then return end

  -- Calculate length of spline needed.
  local splSize = {}
  for mti,mt_desc in ipairs(mt_table) do
    if not splSize[mt_desc.lane] then
      splSize[mt_desc.lane] = 0
    end

    if #mt_desc.taps > 0 then
      if mt_desc.taps[#mt_desc.taps] > splSize[mt_desc.lane] then
        splSize[mt_desc.lane] = mt_desc.taps[#mt_desc.taps]
      end
    end
  end

  -- Convert to 192nds count.
  for i,v in ipairs(splSize) do
    splSize[i] = _BB(v) + 2
  end



  -- Apply the spline points.
  local pp = GetPlayerAF(pn)
  local nf = pp:GetChild('NoteField')
  local ncr_table = nf:GetColumnActors()

  -- Apply the false explosion callback.
  nf:SetDidTapNoteCallback(_G["multitap_note_callback_P"..pn])

  for lane,ncr in ipairs(ncr_table) do
    if splSize[lane] then

      -- Allocate spline space and set up the interpretation
      -- (1 point per 192nd note starting at 0, non-beat-subtracting offset)
      splHandle = ncr:GetZoomHandler()
      splHandle:SetSplineMode('NoteColumnSplineMode_Offset')
           :SetSubtractSongBeat(false)
           :SetReceptorT(0.0)
           :SetBeatsPerT(1/48)
      local splObject = splHandle:GetSpline()
      splObject:SetSize(splSize[lane])
      for spli = 1,splSize[lane] do
        splObject:SetPoint(spli, {0, 0, 0})
      end

      -- Set every 192nd note within the multitap region to offset zoom by -1
      -- (i.e., hide the note by zooming it away)
      for mti,mt_desc in ipairs(mt_table) do
        if (mt_desc.lane == lane) and (#mt_desc.taps > 0) then
          for spli=_BB(mt_desc.taps[1]),_BB(mt_desc.taps[#mt_desc.taps]) do
            splObject:SetPoint(spli+1, {-1, -1, -1})
            --Trace("::: "..lane..".("..spli.." of "..splSize[lane]..") or ("..(spli/48)..")")
          end
        end
      end

      -- Calculate and apply spline
      splObject:Solve()
    end
  end
end

local lane_permute = function(pops, l)
  -- Which lane is the desired arrow in?
  -- Account for Left, Right, and Mirror.
  -- Otherwise I honestly don't give heck. You are on your lonesome binch. Tohoku Evolved up in this jawn
  local lanes = {1, 2, 3, 4}

  if pops:Mirror()   then lanes = {lanes[4], lanes[3], lanes[2], lanes[1]} end
  if pops:Left()    then lanes = {lanes[2], lanes[4], lanes[1], lanes[3]} end
  if pops:Right()   then lanes = {lanes[3], lanes[1], lanes[4], lanes[2]} end

  return lanes[l]
end
local lane_rotation = {90, 0, 180, 270}          -- Give a tap note actor directions. It lost its GPS and has no concept of "land marks"

local copy_transforms = function(dst, src)
  -- All the
  -- Small things
  -- dst gets
  -- What src brings
  -- Tap, fake, or lift
  -- Transform your shit
  dst:x(src:GetX())
     :y(src:GetY())
     :z(src:GetZ())
     :rotationx(src:GetRotationX())
     :rotationy(src:GetRotationY())
     :rotationz(src:GetRotationZ())
--     :zoom(src:GetZoom())
     :zoomx(src:GetZoomX())
     :zoomy(src:GetZoomY())
     :zoomz(src:GetZoomZ())
end

-- Why is this so inaccessibly hard!!
local GRAY_ARROWS_Y_STANDARD     = THEME:GetMetric("Player", "ReceptorArrowsYStandard")
local GRAY_ARROWS_Y_REVERSE      = THEME:GetMetric("Player", "ReceptorArrowsYReverse")
local CENTER_Y_FOR_DILLWEEDS_ONLY  = (GRAY_ARROWS_Y_STANDARD + GRAY_ARROWS_Y_REVERSE) / 2
Trace("### "..CENTER_Y_FOR_DILLWEEDS_ONLY.."x engineers can "..
    "convert 'thought' into 'piss' in their balls, and issue it in an iterative fashion.")

local __SCALE = function(x, l1, h1, l2, h2)
  return (h2 - l2) * (x - l1) / (h1 - l1) + l2
end

--[[
  See also (in the stepmania source code):

  PlayerNoteFieldPositioner()
  PushPlayerMatrix()
  LoadMenuPerspective(
    fovDegrees=45,
    fWidth=SCREEN_WIDTH,
    fHeight=SCREEN_HEIGHT,
    fVanishPointX=SCALE(skew, 0.1f, 1.0f, x, SCREEN_CENTER_X),
    fVanishPointY=center_y
  )
]]--

local copy_transforms_player = function(dst, pp, skew, tilt, reverse)
  -- I probably ought to refactor this code a bit to reduce the parameter bus
  -- but we all goin to school today!! get your notebooks and noteskins

  skew = skew or 0.0
  tilt = tilt or 0.0
  reverse = reverse or false

  -- you know we could just have a god damn API call for this
  -- "I don't see a use case" yeah because your FOV is only 45 degrees!! owned
  local fov_in = 45
  local vpx_in = __SCALE(skew, 0.1, 1.0, pp:GetX(), SCREEN_CENTER_X)
  local vpy_in = pp:GetY() + CENTER_Y_FOR_DILLWEEDS_ONLY
  --Trace("### ... "..vpx_in..", "..vpy_in)

  local reverse_mult = (reverse and -1 or 1)
  local tilt_degrees = __SCALE(tilt, -1, 1, 30, -30) * reverse_mult
  local zoom_for_dipsticks_only = 0
  local yoff_for_dumbdumbs_only = 0
  if (tilt > 0) then
    zoom_for_dipsticks_only = __SCALE(tilt, 0, 1, 1, 0.9)
    yoff_for_dumbdumbs_only = __SCALE(tilt, 0, 1, 0, -45) * reverse_mult
  else
    zoom_for_dipsticks_only = __SCALE(tilt, 0, -1, 1, 0.9)
    yoff_for_dumbdumbs_only = __SCALE(tilt, 0, -1, 0, -20) * reverse_mult
  end

  -- "The iniquity of the parents on the children, and the children's
  -- children, to the third and the fourth generation." -- Exodus 34:7
  dst:GetParent():x(pp:GetX())
           :y(pp:GetY())
           :z(pp:GetZ())
  -- FOV here stands for "fuck off, venerated_stepmania_developers"
              :fov(fov_in)
              :vanishpoint(vpx_in, vpy_in)

    nf = pp:GetChild("NoteField")
  dst:x(nf:GetX())
     :y(nf:GetY() + yoff_for_dumbdumbs_only)
     :z(nf:GetZ())
     :rotationx(nf:GetRotationX())
     :rotationy(nf:GetRotationY())
     :rotationz(nf:GetRotationZ())
     :zoomx(nf:GetZoomX() * zoom_for_dipsticks_only)
     :zoomy(nf:GetZoomY() * zoom_for_dipsticks_only)
     :zoomz(nf:GetZoomZ() * zoom_for_dipsticks_only)
end

local copy_transforms_arrow = function(dst, arrow_only, ps, lane, beat, pos, apply_extra)
  -- Additional translation and rotation are added.
  -- Additional zoom is multiplied.
  -- It's Only Natural

  -- For when the recipe calls for "one clove of garlic" and
  -- you know that isn't right
  apply_extra = apply_extra and apply_extra or {}

  -- Each arrow in its travels acquires a mystical quantity "YOffset",
  -- which dictates its location along the arrow path and when various
  -- arrow effects are applied.
  local y_off = ArrowEffects.GetYOffset(ps, lane, beat + pos) - ArrowEffects.GetYOffset(ps, lane, beat)

  if arrow_only then
    -- Don't rotate the multitap countdown.
    dst:rotationx(ArrowEffects.GetRotationX(ps, y_off, 0, lane)     + (apply_extra["rotationx"] and apply_extra["rotationx"] or 0) + MYSTERIOUS_VERSION_DEPENDENT_RADIAN_POLTERGEIST)  -- ??????
       :rotationy(ArrowEffects.GetRotationY(ps, y_off, lane)       + (apply_extra["rotationy"] and apply_extra["rotationy"] or 0))
       :rotationz(ArrowEffects.GetRotationZ(ps, beat+pos, false, lane)   + (apply_extra["rotationz"] and apply_extra["rotationz"] or 0))
--       :glow(color(1, 1, 1, ArrowEffects.GetGlow(ps, lane, y_off)))    -- TODO: Seems to be always 1? that's weird. I'll fix this when it's actually important
  else
    dst:x(ArrowEffects.GetXPos(ps, lane, y_off)      + (apply_extra["x"] and apply_extra["x"] or 0))
       :y(ArrowEffects.GetYPos(ps, lane, y_off)     + (apply_extra["y"] and apply_extra["y"] or 0))
       :z(ArrowEffects.GetZPos(ps, lane, y_off)        + (apply_extra["z"] and apply_extra["z"] or 0))
       :zoomx(ArrowEffects.GetZoom(ps, y_off, lane)   * (apply_extra["zoomx"] and apply_extra["zoomx"] or 1))
       :zoomy(ArrowEffects.GetZoom(ps, y_off, lane)   * (apply_extra["zoomy"] and apply_extra["zoomy"] or 1))
       :zoomz(ArrowEffects.GetZoom(ps, y_off, lane)    * (apply_extra["zoomz"] and apply_extra["zoomz"] or 1))
       :diffusealpha(ArrowEffects.GetAlpha(ps, lane, y_off))

  end
end


local multitap_update_function = function()
  local status = 1
--  local status, errmsg = pcall( function() -- begin pcall()
    local beat = GAMESTATE:GetSongBeat()

    for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
      local pn = tonumber(string.match(pe, "[0-9]+"))

      local ps   = GAMESTATE:GetPlayerState('PlayerNumber_P'..pn)
      local pp   = GetPlayerAF(pn)
      local pops   = ps:GetPlayerOptions("ModsLevel_Song")

      -- This is a convenient enough spot to do just-in-time one-time initialization lol
      if not multitap_splines_calc[pn] then
        -- Select the multitap list that matches the current chart slot.
        full_chart_name = GAMESTATE:GetCurrentSteps(pn-1):GetDifficulty()
        multitap_chart_sel[pn] = string.sub(full_chart_name, 12)

        -- Calculate vanishing splines for real taps in multitap regions.
        calc_zoom_splines(multitaps[multitap_chart_sel[pn]], pn)
        multitap_splines_calc[pn] = true
      end

      -- --------------------------------------------------------------------------------
      -- only continue with update function if this stepchart has multitap data  -quietly
      if multitaps[multitap_chart_sel[pn]] then

        -- Adjust the multitap fields with the same transforms the players themselves get.
        -- See Player::PlayerNoteFieldPositioner::PlayerNoteFieldPositioner().
        copy_transforms_player(
          multitap_fields[pn],
          pp,
          pops:Skew(),
          pops:Tilt(),
          pops:GetReversePercentForColumn(0) > 0.5    -- ...sure, whatecer
        )

        -- Read the texture coordinate shift that changes quantization in the noteskin.
        -- Some noteskins are implemented as vertical shifts and some horizontal.
        local tex_color_interval = {
          x = NOTESKIN:GetMetricFForNoteSkin("", "TapNoteNoteColorTextureCoordSpacingX", noteskin_names[pn]),
          y = NOTESKIN:GetMetricFForNoteSkin("", "TapNoteNoteColorTextureCoordSpacingY", noteskin_names[pn]),
        }
        local tex_color_is_rhythm = NOTESKIN:GetMetricBForNoteSkin("", "TapNoteAnimationIsVivid", noteskin_names[pn])
        if multitap_chart_sel[pn] then
          local show_false_explosion = {false, false, false, false}

          for mti,mt_desc in ipairs(multitaps[multitap_chart_sel[pn]]) do
			if mt_desc["type"] == "Drill" then
				--playerStats.goal[pn] = mt_desc["goal"]	
			end
            -- I just wanna know how to present a multitap at this time.
            -- Let someone else do the calculations
            mt_stats = calc_multitap_phase(mt_desc, beat, pn)
		    	  local countText = mt_desc["type"] == "Drill" and "count2" or "count"


            local lperm = lane_permute(pops, mt_desc.lane)    -- Where does this arrow actually land?

            if mt_stats.vis then
              --Trace("??? "..pp:GetChild("NoteField"):GetY())
              --Trace("!!! reproach "..pn..", "..mti.." @ "..beat.." + "..mt_stats.pos.." -> "..y_off.." ("..pos_x..", "..pos_y..", "..pos_z..")")

              -- Show the multitap.
              --    Turn the arrow actor to the right lane direction
              --    Dim the arrow to make the countdown stand out initially
              --    Set the arrow color to the right quantization
              multitap_actors[pn][mti]["frame"]:visible(true)

              multitap_actors[pn][mti]["arrow"]:baserotationz(lane_rotation[lperm])
                               :diffuse(lerp_color(mt_stats.dif, color("#666666"), color("#ffffff")))
                               :texturetranslate(
                tex_color_interval["x"] * qtzn_tex[mt_stats.qtc],
                tex_color_interval["y"] * qtzn_tex[mt_stats.qtc]
                )

              -- To make the multitap convincing, spoof the transformation matrices
              -- and color modifiers from the same calculations as a real tap note.
              copy_transforms_arrow(
                multitap_actors[pn][mti]["frame"], false,
                ps,
                lperm,
                beat,
                mt_stats.pos,
                {zoomy = 1 + mt_stats.sqh}
              )
              copy_transforms_arrow(
                multitap_actors[pn][mti]["arrow"], true,
                ps,
                lperm,
                beat,
                mt_stats.pos,
                {}
              )
              if mt_desc["type"] == "Drill" then
                multitap_actors[pn][mti]["arrow"]:visible(false)
                multitap_actors[pn][mti]["ball"]:visible(true)
              else
                multitap_actors[pn][mti]["arrow"]:visible(true)
                multitap_actors[pn][mti]["ball"]:visible(false)

              end

              -- Be prepared to fire a fake explosion if any multitap in this lane is active.
              show_false_explosion[lperm] = true

              if mt_stats.rem > 1 then
                -- Show the countdown until this multitap degrades into a regular tap
                -- (i.e., 1 hit left)

                -- Use color tables to coordinate with the noteskin and quantization.
                local noteskin_name = noteskin_names[pn]
                local color_pair = qtzn_color_tables["vivid"][1]
                if qtzn_color_tables[noteskin_name] and not tex_color_is_rhythm then
                  color_pair = qtzn_color_tables[noteskin_name][qtzn_tex[mt_stats.qtn]+1]
                end

                -- Set the text actor up with the right number, and a pulsating
                -- color effect similar to what you'd see on most tap notes.
                multitap_actors[pn][mti][countText]:visible(true)
                                 :settext(mt_stats.rem)
                                 :zoom(1)
                                 :diffuseramp()
                                 :effectclock("beat")
                                 :effectcolor1(color("#"..color_pair[1]))
                                 :effectcolor2(color("#"..color_pair[2]))
              else
                multitap_actors[pn][mti][countText]:visible(false)
				if mt_desc["type"] == "Drill" then
				end
              end
            else
              multitap_actors[pn][mti]["frame"]:visible(false)
            end
          end

          for lane=1,4 do
            local lperm = lane_permute(pops, lane)    -- Where does this arrow actually land?

            -- Show the spoofed explosion if we need it, and make sure it's
            -- in the right spot.
            local ex_pos_x = ArrowEffects.GetXPos(ps, lperm, 0)
            local ex_pos_y = ArrowEffects.GetYPos(ps, lperm, 0)
            local ex_pos_z = ArrowEffects.GetZPos(ps, lperm, 0)

            -- TODO: I guess I could incorporate individual column zoom
            -- into this too, but no default mods affect that.
            multitap_explosions[pn][lperm]:xy(ex_pos_x, ex_pos_y)
                            :z(ex_pos_z)
                            :baserotationz(lane_rotation[lperm])
                            :visible(show_false_explosion[lperm])
          end
        end
      end
    end

    TEST_last_beat = beat
--  end -- end pcall()
--  )
  if status then
    --Trace('### YAY TELP DID NOT MAKE A FUCKY WUCKY')
  else
    if not multitap_error then
      Trace('### OOPS TELP HAS MADE A FUCKO BOINGO (in update function)')
      Trace('### '..errmsg)
      Trace('### '..debug.traceback())
    end
  end
end


direction_names = {"Left", "Down", "Up", "Right"}
for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
  local pn = tonumber(string.match(pe, "[0-9]+"))

  local pops = GAMESTATE:GetPlayerState(pe):GetPlayerOptions("ModsLevel_Song")
  local noteskin_name = string.lower(pops:NoteSkin())
  noteskin_names[pn] = noteskin_name

  -- Build out the bags of holding for all the multitap-related actors
  -- (explosions per lane, frames that hold arrows and countdowns)
  local multitap_prep = Def.ActorFrame {
    Name="MultitapFrameP"..pn,
    InitCommand = function(self)
    end,
    OnCommand = function(self)
      multitap_fields[pn] = self
    end,
  }

  for lane=1,4 do
    -- All noteskins should have a suitable actor that accommodates
    -- explosions of all grades.
    -- If this assumption fails, I wanna know about it :P
    multitap_prep[#multitap_prep+1] = NOTESKIN:LoadActorForNoteSkin("Down", "Explosion", noteskin_name)..{
      Name="MultitapExplosionP"..pn.."_"..lane,
      InitCommand=function(self)
      end,
      OnCommand=function(self)
        multitap_explosions[pn][lane] = self
        self:visible(true)
        --Trace("=== Added multitap actor explosion for P"..pn..", lane "..lane)
      end,
    }
  end

  for mti = 1,multitap_max do
    -- Each multitap is an ActorFrame with two elements:
    --     A tap note loaded from the ative noteskin
    --    A text actor to show the remaining tap count
    multitap_prep[#multitap_prep+1] = Def.ActorFrame {
      Name="MultitapP"..pn.."_"..mti,
      InitCommand=function(self)
      end,
      OnCommand=function(self)
        local i = mti

        multitap_actors[pn][i]["frame"] = self
        self:visible(false)

        --Trace("=== Added multitap actor frame for P"..pn..", index "..i)
      end,
      NOTESKIN:LoadActorForNoteSkin("Down", "Tap Note", noteskin_name)..{
        Name="MultitapArrowP"..pn.."_"..mti,
        InitCommand=function(self)
        end,
        OnCommand=function(self)
          local i = mti

          multitap_actors[pn][i]["arrow"] = self
          self:visible(true)
          --Trace("=== Added multitap actor arrow for P"..pn..", index "..i)
        end,
      },
      Def.Sprite {
				Texture="ball.png",
				OnCommand= function(self)
					multitap_actors[pn][mti]["ball"] = self
					self:visible(true):animate(false):zoom(0.17)
					self:addy(4)
				end,
	
			},
      Def.BitmapText {
        -- You can switch the font out, but I recommend:
        -- *  36-48px (42px is ideal; keep in mind arrows are 64px)
        -- *  Generate it with 10px+ padding and add a nice bold
        --    border in post, at least 4px, to distinguish it well
        --    from the underlying arrow
        Name="MultitapTextP"..pn.."_"..mti,
        Font="_komika axis 42px.ini",
        Text="",
        InitCommand=function(self)
        end,
        OnCommand=function(self)
          local i = mti

          multitap_actors[pn][i]["count"] = self
          self:visible(false)
            :z(10.0)            -- Ensure depth z-testing
                            -- (even though SM5 defaults to init order because That`s Great!)
            :strokecolor(color("#000000"))
          --Trace("=== Added multitap actor count for P"..pn..", index "..i)
        end,
      },
	  Def.BitmapText {
        -- You can switch the font out, but I recommend:
        -- *  36-48px (42px is ideal; keep in mind arrows are 64px)
        -- *  Generate it with 10px+ padding and add a nice bold
        --    border in post, at least 4px, to distinguish it well
        --    from the underlying arrow
        Name="MultitapTextP"..pn.."_"..mti,
        Font="_poor richard 50px.ini",
        Text="",
        InitCommand=function(self)
        end,
        OnCommand=function(self)
          local i = mti

          multitap_actors[pn][i]["count2"] = self
          self:visible(false)
            :z(10.0)            -- Ensure depth z-testing
                            -- (even though SM5 defaults to init order because That`s Great!)
            :strokecolor(color("#000000")):zoom(0.80)
          --Trace("=== Added multitap actor count for P"..pn..", index "..i)
        end,
      },
    }
  end

  -- The multitap bags of holding need one level of parent to handle
  -- FOV and positioning in the most accurate way.
  -- I probably could have used a wrapper state here...
  multitap_parent[#multitap_parent+1] = Def.ActorFrame{multitap_prep}
end

multitap_parent[#multitap_parent+1] = Def.ActorFrame {
  Name="Update",
  InitCommand=function(self)
    Trace("### im alive")

    -- Do all of the it
    self:SetUpdateFunction(multitap_update_function)
  end,

  Def.ActorFrame {
    InitCommand = function(self)
      self:sleep(69420)
    end
  },
  Def.ActorFrame {
    InitCommand = function(self)
      self:x(0.2*SCREEN_WIDTH/4):y(2.5*SCREEN_HEIGHT/4):rotationz(90)
    end,
    HideMessageCommand=function(self)
      self:linear(1):diffusealpha(0)
    end,
    BidenBlastCheckMessageCommand=function(self)
      -- Check if p1 reached the goal
      if (GetPlayerAF(1)) then
        if (not playerStats.pass[1][1] and not playerStats.pass[1][1]) then
          self:queuecommand("BidenBlast")
        end
      end
    end,
    BidenBlastCommand=function(self)
      self:sleep(2):accelerate(4):diffusealpha(0)
    end,
    Def.Quad {
      InitCommand = function(self)
        self:visible(false)
      end,
      BidenBlastCommand=function(self)
        self:sleep(1.75):queuecommand("DestroyArrow")
      end,
      DestroyArrowCommand=function(self)
        GetPlayerAF(1):vibrate():linear(2):addy(-SCREEN_HEIGHT)
      end
    },
    Def.Sprite{
      Frames = {												
        {Frame=0,Delay=0.5},
        {Frame=1,Delay=0.15},
        {Frame=2,Delay=0.15},
        {Frame=3,Delay=0.15},
        {Frame=4,Delay=0.15},
        {Frame=5,Delay=0.15},
        {Frame=6,Delay=5},
      };
          Texture = 'MajinVegeta 3x3.png';
          InitCommand = function(self) 
            self:visible(false):zoom(0.75):animate(false):croptop(0.005)
          end,
          BidenBlastCommand=function(self)
            self:visible(true):animate(true):loop(false)
          end
      },
      Def.Sprite{
            Texture = 'kiBlast 3x2.png';
            InitCommand = function(self) 
              self:animate(false):visible(false):zoom(3)
            end,
            BidenBlastCommand=function(self)
              self:sleep(0.5+(0.15*5)+0.15):queuecommand("Animate")
            end,
            AnimateCommand = function(self)
              self:finishtweening():animate(true):visible(true):rotationz(180):SetAllStateDelays(0.05):addx(-190)
            end
        },
    },
    Def.ActorFrame {
      InitCommand = function(self)
        self:x(3.7*SCREEN_WIDTH/4):y(2.5*SCREEN_HEIGHT/4):rotationz(90):rotationy(180)
      end,
      HideMessageCommand=function(self)
        self:linear(1):diffusealpha(0)
      end,
      BidenBlastCheckMessageCommand=function(self)
        -- Check if p2 reached the goal
        if (GetPlayerAF(2)) then
          if (not playerStats.pass[2][1] and not playerStats.pass[2][1]) then
            self:queuecommand("BidenBlast")
          end
        end
      end,
      BidenBlastCommand=function(self)
        self:sleep(2):accelerate(4):diffusealpha(0)
      end,
      Def.Quad {
        InitCommand = function(self)
          self:visible(false)
        end,
        BidenBlastCommand=function(self)
          self:sleep(1.75):queuecommand("DestroyArrow")
        end,
        DestroyArrowCommand=function(self)
          GetPlayerAF(2):vibrate():linear(2):addy(-SCREEN_HEIGHT)
        end
      },
      Def.Sprite{
        Frames = {												
          {Frame=0,Delay=0.5},
          {Frame=1,Delay=0.15},
          {Frame=2,Delay=0.15},
          {Frame=3,Delay=0.15},
          {Frame=4,Delay=0.15},
          {Frame=5,Delay=0.15},
          {Frame=6,Delay=5},
        };
            Texture = 'MajinVegeta 3x3.png';
            InitCommand = function(self) 
              self:visible(false):zoom(0.75):animate(false):croptop(0.005)
            end,
            BidenBlastCommand=function(self)
              self:visible(true):animate(true):loop(false)
            end
        },
        Def.Sprite{
              Texture = 'kiBlast 3x2.png';
              InitCommand = function(self) 
                self:animate(false):visible(false):zoom(3)
              end,
              BidenBlastCommand=function(self)
                self:sleep(0.5+(0.15*5)+0.15):queuecommand("Animate")
              end,
              AnimateCommand = function(self)
                self:finishtweening():animate(true):visible(true):rotationz(180):SetAllStateDelays(0.05):addx(-190)
              end
          },
      },
}



-- Done!
return multitap_parent
